if (name_input_active) {
    // Capture keyboard input
    global.player_name = keyboard_string;

    // Confirm name input with Enter key
    if (keyboard_check_pressed(vk_enter)) {
        name_input_active = false; // Exit input mode
        room_goto(rm_level1); // Proceed to the game
    }

    // Allow canceling input with Escape key
    if (keyboard_check_pressed(vk_escape)) {
        name_input_active = false; // Exit input mode
        global.player_name = ""; // Reset the name if canceled
    }
} else {
    // Input handling for menu navigation
    up_key = keyboard_check_pressed(vk_up);
    down_key = keyboard_check_pressed(vk_down);
    accept_key = keyboard_check_pressed(vk_enter);

    // Get the number of options in the current menu
    op_length = array_length(option[menu_level]);

    // Navigate through the menu
    pos += down_key - up_key;
    if (pos >= op_length) pos = 0;
    if (pos < 0) pos = op_length - 1;

    // Handle option selection
    if (accept_key) {
        var _sml = menu_level;

        switch (menu_level) {
            case 0: // Main menu
                switch (pos) {
                    case 0: // New Game
                        menu_level = 6; // Move to the name input submenu
                        keyboard_string = ""; // Reset input string
                        break;
                    case 1: // Load Game
                        if (load_game()) {
                            room_goto(rm_level1); // Proceed to the saved room
                        } else {
                            show_message("No save file found!");
                        }
                        break;
                    case 2: // Settings
                        menu_level = 1;
                        break;
                    case 3: // Leaderboard
                        menu_level = 3;
                        break;
                    case 4: // Quit Game
                        game_end();
                        break;
                }
                break;

            case 1: // Settings menu
                switch (pos) {
                    case 0: menu_level = 2; break; // Window Size
                    case 1: menu_level = 5; break; // Controls
                    case 2: menu_level = 4; break; // Objective
                    case 3: menu_level = 0; break; // Back to Main Menu
                }
                break;

            case 2: // Window Size submenu
                switch (pos) {
                    case 0:
                        if (option[2][0] == "Window Size: 1x") {
                            option[2][0] = "Window Size: 2x";
                            window_set_size(1024, 768);
                        } else if (option[2][0] == "Window Size: 2x") {
                            option[2][0] = "Window Size: 3x";
                            window_set_size(1536, 1024);
                        } else {
                            option[2][0] = "Window Size: 1x";
                            window_set_size(864, 648);
                        }
                        break;
                    case 1:
                        global.fullscreen_enabled = !global.fullscreen_enabled;
                        window_set_fullscreen(global.fullscreen_enabled);
                        break;
                    case 2: menu_level = 1; break; // Back to Settings
                }
                break;

            case 3: // Leaderboard menu
                if (pos == array_length(option[3]) - 1) {
                    menu_level = 0; // Back to Main Menu
                }
                break;

            case 4: // Objective submenu
                if (pos == 1) menu_level = 1; // Back to Settings
                break;

            case 5: // Controls submenu
                if (pos == 4) menu_level = 1; // Back to Settings
                break;

            case 6: // Name input submenu
                switch (pos) {
                    case 0: // Enter your name
                        // Capture keyboard input
                        global.player_name = keyboard_string;
                        break;
                    case 1: // Accept
                        name_input_active = false; // Exit input mode
                        room_goto(rm_level1); // Proceed to the game
                        break;
                    case 2: // Back
                        menu_level = 0; // Return to the main menu
                        break;
                }
                break;
        }

        // Reset position and recalculate size when menu changes
        if (_sml != menu_level) {
            pos = 0;
            calculate_menu_size();
        }
    }

    // Play a sound when navigating
    if (pos != last_selected) {
        audio_play_sound(select, 1, false);
        last_selected = pos;
    }
}
